<?php
/**
 * tsShorturl
 * 
 * @version    1.2.0
 * @author     Markus Nolte
 * @copyright  Copyright (c) 2019 Top-Side.de
 * @link       https://www.top-side.de
 * @license    GPLv3 (https://www.gnu.org/licenses/gpl-3.0.html)
 * 
 */

include("config.php");
$db = mysqli_connect($db_server, $db_user, $db_passwd, $db_name);

echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n";
echo "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\n<head>\n";
echo "<title>".$page_title."</title>\n";

echo "<meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\" />\n";

echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\" />\n";
echo "</head>\n\n";

echo "<body>\n";

echo "<div class=\"header\">\n";
echo "<a href=\"index.html\"><img src=\"images/header.png\" alt=\"header\" /></a>\n";
echo "</div>\n";

echo "<div class=\"menu\">\n";
echo "<img src=\"images/statistic.png\" alt=\"statistik\" /><a href=\"statistik.html\">Statistik</a>\n";
echo "<img src=\"images/faq.png\" alt=\"faq\" /><a href=\"faq.html\">F.A.Q.</a>\n";
echo "<img src=\"images/contact.png\" alt=\"kontakt\" /><a href=\"kontakt.html\">Kontakt</a>\n";
echo "</div>\n";

echo "<div class=\"content\">\n";
$page = (isset($_GET['page']) && !empty($_GET['page'])) ? $_GET['page'] : "index";
switch($page)
{
	case "statistik":
	{
		$query = $db->query("SELECT COUNT(id) AS sum_urls FROM short_urls");
		$result = $query->fetch_object();
		$sum_urls = $result->sum_urls;
		echo "<strong>".number_format($sum_urls, 0, ",", ".")."</strong> URLs mit\n";
		$query->close();
		$query = $db->query("SELECT SUM(hits) AS sum_clicks FROM short_urls");
		$result = $query->fetch_object();
		$sum_clicks = $result->sum_clicks;
		echo "<strong>".number_format($sum_clicks, 0, ",", ".")."</strong> Klicks\n";
		$query->close();
		echo " (&oslash; ".number_format(round($sum_clicks / $sum_urls), 0, ",", ".")." Klicks / URL)<br /><br />\n";
		echo "<strong>Top 10 URLs</strong><br /><br />\n";
		function trim_url($url)
		{
			$shorturl = $url;
			if(strlen($url) > 40)
				$shorturl = substr($url, 0, 40)."...";
			return $shorturl;
		}
		echo "<table>\n";
		echo "<tr style=\"font-weight: bold\"><td style=\"width: 50px\">ID</td><td>URL</td><td>Klicks</td></tr>\n";
		$query = $db->query("SELECT id, url, hits FROM short_urls ORDER BY hits DESC LIMIT 10");
		while($result = $query->fetch_object())
		{
			$long_url = str_replace("&", "&amp;", $result->url);
			$id = base_convert($result->id, 10, 36);
			echo "<tr>\n";
			echo "<td><a href=\"".$page_url.$id."\">".$id."</a></td>\n";
			echo "<td title=\"".$long_url."\">".trim_url($long_url)."</td>\n";
			echo "<td>".number_format($result->hits, 0, ",", ".")."</td>\n";
			echo "</tr>\n";
		}
		$query->close();
		echo "</table>\n";
		break;
	}
	case "faq":
	{
		echo "<strong>Was ist ".$page_title."?</strong><br />\n";
		echo "Mit ".$page_title." kann aus einer langen URL eine sehr kurze URL erstellt werden.<br /><br />\n";
		echo "Beispiel:<br />\n";
		echo "<div class=\"highlight\">";
		echo "http://www.amazon.de/b%C3%BCcher-buch-literatur/b/ref=sa_menu_bo0?ie=UTF8&amp;node=299956&amp;pf_rd_p=218611391&amp;pf_rd_s=left-nav-1&amp;pf_rd_t=101&amp;pf_rd_i=301128&amp;pf-rd_m=A3JWKAKR8XB7XF&amp;pf_rd_r=0J477PHX6YSH56KNTYAA";
		echo "</div>\n";
		echo "<br />\nwird zu:<br /><div class=\"highlight\">".$page_url."a4k</div>\n<br />\n";
		echo "<strong>Wie lange bleiben die URLs erhalten?</strong><br />\n";
		if($del_urls)
			echo "URLs werden nach ".$del_urls." Tagen ohne Klick / Aufruf gel&ouml;scht.<br /><br />\n";
		else
			echo "URLs werden nie gel&ouml;scht.<br /><br />\n";
		echo "<strong>Kann das Ziel / die Statistik zu einer ID angezeigt werden?</strong><br />\n";
		echo "Ja, einfach die ID in das URL-Feld eingeben.<br /><br />\n";
		echo "<strong>Gibt es ein Bookmarklet?</strong><br />\n";
		echo "Ja, dazu den folgenden Link <a href=\"javascript:location.href='".$page_url."?kuerzen='+encodeURIComponent(location.href)\">".$page_title."</a> zu den Favoriten / der Adressleiste hinzuf&uuml;gen.\n";
		break;
	}
	case "kontakt":
	{
		echo "<form action=\"kontakt.html\" method=\"post\">\n";
		echo "<p>\nE-Mail Adresse<br /><input type=\"text\" size=\"30\" name=\"sender\" /><br /><br />\n";
		echo "Betreff<br /><input type=\"text\" size=\"30\" name=\"subject\" /><br /><br />\n";
		echo "Nachricht<br /><textarea name=\"text\" rows=\"5\" cols=\"50\"></textarea><br /><br />\n";
		echo "<input type=\"submit\" name=\"send\" value=\"Senden\" />\n</p>\n</form>\n";
		if(isset($_POST['send']))
		{
			if(eregi("^[a-z0-9]+([-_\.]?[a-z0-9])+@[a-z0-9]+([-_\.]?[a-z0-9])+\.[a-z]{2,4}", $_POST['sender']) && !empty($_POST['subject']) && !empty($_POST['text']))
			{
				mail($e_mail, $_POST['subject'], $_POST['text'], "From: ".$_POST['sender']);
				echo "E-Mail wurde gesendet.";
			}
			else
				echo "<span style=\"color: #FF0000\">Formular nicht korrekt ausgef&uuml;llt.</span>";
		}
		break;
	}
	case "admin":
	{
		echo "Zum Admin-Bereich <a href=\"admin.php\">klick hier</a>.\n";
		break;
	}
	case "preview":
	{
		$id = base_convert($_GET['id'], 36, 10);
		$query = $db->query("SELECT url FROM short_urls WHERE id = ".$id);
		if($result = $query->fetch_object())
		{
			$url = $result->url;
			$db->query("UPDATE short_urls SET last_access = CURDATE(), hits = hits + 1 WHERE id = ".$id);
			echo "Weiterleitung nach:<br />\n";
			echo "<a href=\"".$url."\"><strong>".wordwrap($url, 50, "\n", true)."</strong></a>\n";
		}
		else
			echo "<span style=\"color: #FF0000\">ung&uuml;tige Weiterleitung</span>\n"; 
		$query->close();
		break;
	}
	default:
	{
		echo "<form action=\"index.html\" method=\"post\">\n";
		echo "<p>\nURL<br /><input type=\"text\" size=\"50\" name=\"url\" maxlength=\"1000\" />\n";
		echo "<input type=\"submit\" name=\"shortit\" value=\"k&uuml;rzen\" />\n</p>\n";
		echo "</form><br />\n";
		
		if(isset($_POST['shortit']) || isset($_GET['kuerzen']))
		{
			if(isset($_GET['kuerzen']))
				$url_long = $_GET['kuerzen'];
			else
				$url_long = $_POST['url'];
			$url_regex = "/^[\w\-_,\:;~@%&\=\.\/\?\+#]{4,}$/";
			if(preg_match("/^[a-z0-9]{1,7}$/", $url_long))
			{
				$id = base_convert($url_long, 36, 10);
				$query = $db->query("SELECT url, date_format(last_access, '%d.%m.%Y') AS last_access, hits FROM short_urls WHERE id = ".$id);
				if($result = $query->fetch_object())
				{
					$url_amp = str_replace("&", "&amp;", $result->url);
					echo "Weiterleitung nach:<br />\n";
					echo "<a href=\"".$url_amp."\"><strong>".wordwrap($url_amp, 50, "\n", true)."</strong></a><br /><br />\n";
					echo "<strong>".number_format($result->hits, 0, ",", ".")."</strong> Klicks";
					echo " (letzter am ".$result->last_access.")";
				}
				else
					echo "<span style=\"color: #FF0000\">ung&uuml;tige ID</span>\n";
				$query->close();
			}
			else if(!preg_match($url_regex, $url_long))
				echo "<span style=\"color: #FF0000\">ung&uuml;tige URL</span>\n";
			else
			{
				if(!preg_match("/^(http|https|ftp).+$/", $url_long))
					$url_long = "http://".$url_long;
				$query = $db->query("SELECT id FROM short_urls WHERE url = '".$url_long."'");
				if($result = $query->fetch_object())
					$id = $result->id;
				else
				{
					$db->query("INSERT INTO short_urls (url, last_access) VALUES ('".$url_long."', CURDATE())");
					$id = $db->insert_id;
				}
				$query->close();
				$url_short = $page_url.base_convert($id, 10, 36);
				echo "Lange URL (".strlen($url_long)." Zeichen):<br/>\n";
				echo "<strong>".wordwrap(str_replace("&", "&amp;", $url_long), 50, "\n", true)."</strong>";
				echo "\n<br /><br />";
				echo "Kurze URL (".strlen($url_short)." Zeichen):<br/>\n";
				echo "<div class=\"highlight\"><strong>".$url_short."</strong></div>\n";
				echo "<br />\n";
				echo "Kurze URL (mit Vorschau):<br/>\n";
				echo "<strong>".$page_url."v=".base_convert($id, 10, 36)."</strong>";
			}
		}
		break;
	}

}
echo "</div>\n";

echo "</body>\n\n</html>";
?>