<?php
/**
 * tsShorturl
 * 
 * @version    1.2.0
 * @author     Markus Nolte
 * @copyright  Copyright (c) 2019 Top-Side.de
 * @link       https://www.top-side.de
 * @license    GPLv3 (https://www.gnu.org/licenses/gpl-3.0.html)
 * 
 */

include("config.php");
$db = mysqli_connect($db_server, $db_user, $db_passwd, $db_name);

session_start();
$page = (isset($_GET['page'])) ? $_GET['page'] : "index";
if(!isset($_SESSION['login']))
	$_SESSION['login'] = false;

echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n";
echo "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\n<head>\n";
echo "<title>".$page_title." - Adminbereich</title>\n";

echo "<meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\" />\n";

echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\" />\n";
echo "</head>\n\n";

echo "<body>\n";

echo "<div class=\"content\">\n";
if($_SESSION['login'])
{
	echo "<div class=\"highlight\" style=\"text-align: center\">\n";
	echo "<a href=\"admin.php?page=urllist\">URL-Liste</a> | \n";
	echo "<a href=\"admin.php?page=oldurls\">alte URLs l&ouml;schen</a> | \n";
	echo "<a href=\"admin.php?page=search\">URL Suche</a> | \n";
	echo "<a href=\"admin.php?page=logout\">Logout</a>\n";
	echo "</div>\n";
	switch($page)
	{
		case "urllist":
		{
			$search = "";
			if(isset($_GET['search']))
			{
				$search = " WHERE url LIKE '%".$_SESSION['search']."%' ";
				echo "<br />Suche nach: <strong>".$_SESSION['search']."</strong><br />";
				if(!isset($_GET['delsearch']))
				{
					$admin_url = "admin.php?page=urllist&amp;search";
					echo "<img src=\"images/delete.png\" alt=\"loeschen\" />&nbsp;<a href=\"".$admin_url."&amp;delsearch\">Alle URLs aus Suche l&ouml;schen</a>\n";
				}
				else
				{
					$db->query("DELETE FROM short_urls".$search);
					echo "Alle URLs aus Suche gel&ouml;scht\n";
				}
				echo "<br /><br />\n";
			}
			else
				$admin_url = "admin.php?page=urllist";
			$query = $db->query("SELECT COUNT(id) AS sum_urls FROM short_urls".$search);
			$result = $query->fetch_object();
			$sum_urls = $result->sum_urls;
			$query->close();
			if($sum_urls == 0)
				echo "Keine URLs vorhanden.";
			else
			{
				if(!isset($_GET['p']))
					$p = 1;
				else
					$p = $_GET['p'];
				function trim_url($url)
				{
					$shorturl = $url;
					if(strlen($url) > 40)
						$shorturl = substr($url, 0, 40)."...";
					return $shorturl;
				}
				echo "<table>\n";
				echo "<tr style=\"font-weight: bold\"><td style=\"width: 25px\"></td><td style=\"width: 50px\">ID</td><td>URL</td><td>Klicks</td></tr>\n";
				$query = $db->query("SELECT id, url, hits FROM short_urls ".$search." LIMIT ".(($p - 1) * 25).", 25");
				while($result = $query->fetch_object())
				{
					$long_url = str_replace("&", "&amp;", $result->url);
					$id = base_convert($result->id, 10, 36);
					echo "<tr>\n";
					echo "<td><a href=\"".$admin_url."&amp;p=".$p."&amp;delid=".$id."\"><img src=\"images/delete.png\" alt=\"loeschen\" /></a></td>\n";
					echo "<td><a href=\"".$page_url.$id."\">".$id."</a></td>\n";
					echo "<td title=\"".$long_url."\">".trim_url($long_url)."</td>\n";
					echo "<td>".number_format($result->hits, 0, ",", ".")."</td>\n";
					echo "</tr>\n";
				}
				$query->close();
				echo "</table><br />\n";
				
				if(isset($_GET['delid']))
				{
					$db->query("DELETE FROM short_urls WHERE id = ".base_convert($_GET['delid'], 36, 10));
					echo "<meta http-equiv=\"refresh\" content=\"0; URL=".$admin_url."&amp;p=".$p."\">\n";
				}
				
				$pages = ceil($sum_urls / 25);
				if($pages > 1)
				{
					echo "<div class=\"highlight\" style=\"text-align: center\">Seite ".$p." von ".$pages."&nbsp;&nbsp;&nbsp;\n";
					if($p - 1 >= 1)
						echo "<a href=\"".$admin_url."&amp;p=1\">1</a>&nbsp;\n";
					if($p > 4)
						echo "<a href=\"".$admin_url."&amp;p=".($p - 1)."\">&laquo;</a>&nbsp;...&nbsp;\n";
					if($p - 2 > 1)
						echo "<a href=\"".$admin_url."&amp;p=".($p - 2)."\">".($p - 2)."</a>&nbsp;\n";
					if($p - 1 > 1)
						echo "<a href=\"".$admin_url."&amp;p=".($p - 1)."\">".($p - 1)."</a>&nbsp;\n";
					echo "<b>".$p."</b>&nbsp;\n";
					if($p + 1 < $pages)
						echo "<a href=\"".$admin_url."&amp;p=".($p + 1)."\">".($p + 1)."</a>&nbsp;\n";
					if($p + 2 < $pages)
						echo "<a href=\"".$admin_url."&amp;p=".($p + 2)."\">".($p + 2)."</a>&nbsp;\n";
					if($p < $pages - 3)
						echo "<a href=\"".$admin_url."&amp;p=".($p + 1)."\">&raquo;</a>&nbsp;...&nbsp;\n";
					if($p + 1 <= $pages)
						echo "<a href=\"".$admin_url."&amp;p=".$pages."\">".$pages."</a>\n";
				echo "</div>\n";
				}
			}
			break;
		}
		case "oldurls":
		{
			if($del_urls == 0)
				echo "L&ouml;schen ist deaktiviert (config.php).\n";
			else
			{
				$query = $db->query("SELECT COUNT(id) AS sum_urls FROM short_urls WHERE (TO_DAYS(NOW()) - TO_DAYS(last_access)) >= ".$del_urls);
				$result = $query->fetch_object();
				$sum_urls = $result->sum_urls;
				$query->close();
				if($sum_urls > 0)
				{
					echo "<p>".number_format($sum_urls, 0, ",", ".")." URLs ohne Klick in den letzten ".$del_urls." Tage vorhanden.</p>\n";
					echo "<form action=\"admin.php?page=oldurls\" method=\"post\">\n";
					echo "<p>\n<input type=\"submit\" name=\"del_urls\" value=\"URLs l&ouml;schen\" />\n</p>\n";
					echo "</form>\n";
				}
				else
					echo "Keine URLs ohne Klick in den letzten ".$del_urls." Tage vorhanden.\n";
				
				if(isset($_POST['del_urls']))
				{
					$db->query("DELETE FROM short_urls WHERE (TO_DAYS(NOW()) - TO_DAYS(last_access)) >= ".$del_urls);
					echo "URLs gel&ouml;scht\n";
				}
			}
			break;
		}
		case "search":
		{
			echo "<form action=\"admin.php?page=search\" method=\"post\">\n";
			echo "<p>\nID oder URL (auch Teilurl, z. B. test.de/ordner1)<br /><input type=\"text\" name=\"url_search\" size=\"50\" />\n";
			echo "<input type=\"submit\" name=\"search\" value=\"suchen\" />\n</p>\n";
			echo "</form>\n";
			
			if(isset($_GET['delid']))
			{
				$db->query("DELETE FROM short_urls WHERE id = ".base_convert($_GET['delid'], 36, 10));
				echo "URL gel&ouml;scht.";
			}
			
			if(isset($_POST['search']))
			{
				$url_search = $_POST['url_search'];
				$url_regex = "/^[\w\-_,\:~@%&\=\.\/\?\+#]{4,}$/";
				if(preg_match("/^[a-z0-9]{1,7}$/", $url_search))
				{
					$id = base_convert($url_search, 36, 10);
					$query = $db->query("SELECT url, date_format(last_access, '%d.%m.%Y') AS last_access, hits FROM short_urls WHERE id = ".$id);
					if($result = $query->fetch_object())
					{
						$url_amp = str_replace("&", "&amp;", $result->url);
						echo "Weiterleitung nach:<br />\n";
						echo "<a href=\"".$url_amp."\"><strong>".wordwrap($url_amp, 50, "\n", true)."</strong></a><br /><br />\n";
						echo "<strong>".number_format($result->hits, 0, ",", ".")."</strong> Klicks";
						echo " (letzter am ".$result->last_access.")<br /><br />\n";
						echo "<img src=\"images/delete.png\" alt=\"loeschen\" />&nbsp;<a href=\"admin.php?page=search&amp;delid=".$url_search."\">URL l&ouml;schen</a>\n";
					}
					else
						echo "<span style=\"color: #FF0000\">ung&uuml;tige ID</span>\n";
					$query->close();
				}
				else if(!preg_match($url_regex, $url_search))
					echo "<span style=\"color: #FF0000\">ung&uuml;tige URL</span>\n";
				else
				{
					$_SESSION['search'] = $url_search;
					echo "<meta http-equiv=\"refresh\" content=\"0; URL=admin.php?page=urllist&amp;search\">\n";
				}
			}
			break;
		}
		case "logout":
		{
			unset($_SESSION['login']);
			echo "<meta http-equiv=\"refresh\" content=\"0; URL=admin.php\">\n";
		}
	}
}
else
{
	echo "<form action=\"admin.php\" method=\"post\">\n";
	echo "<p>\nPasswort<br /><input type=\"password\" name=\"passwd\" size=\"25\" />\n";
	echo "<input type=\"submit\" name=\"login\" value=\"login\" />\n</p>\n";
	echo "</form>\n";
	if(isset($_POST['login']))
	{
		if($_POST['passwd'] == $passwd)
		{
			$_SESSION['login'] = true;
			echo "Login erfolgreich. Zum Admin-Bereich <a href=\"admin.php\">klick hier</a>.\n";
		}
		else
			echo "<span style=\"color: #FF0000\">falsches Passwort</span>\n";
	}
}
echo "</div>\n";
echo "</body>\n\n</html>";
?>